<!DOCTYPE html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="shortcut icon" href="<?php echo e(url('assets/images/logo/' . (system_setting('favicon_icon') ?? null))); ?>" type="image/x-icon">
    <title><?php echo e(__('Reset Password')); ?>|| <?php echo e(config('app.name')); ?></title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
    <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
    <?php echo $__env->make('layouts.include', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12 col-lg-8" style="margin-top:50px">
                <div class="card">

                    <div class="card-body">
                    <form method="POST" class="create-form" action="<?php echo e(route('customer.reset-password')); ?>" data-success-function="formSuccessFunction">
                            <input type="hidden" name="token" value="<?php echo e($token); ?>">

                            <div class="row mb-3">
                                
                                <label for="password" class="col-form-label"><?php echo e(__('Password')); ?></label>
                                <div class="col-12">
                                    <input id="password" type="password" class="form-control" name="password" placeholder="<?php echo e(__('Password')); ?>" required>
                                </div>

                                
                                <label for="re-password" class="col-form-label"><?php echo e(__('Re-Password')); ?></label>
                                <div class="col-12">
                                    <input id="re-password" type="password" class="form-control" name="re_password" placeholder="<?php echo e(__('Re-Password')); ?>" required>
                                </div>
                            </div>

                            <div class="row mb-0">
                                <div class="col-md-6 offset-md-4">
                                    <button type="submit" class="btn btn-primary">
                                        <?php echo e(__('Reset Password')); ?>

                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
<?php echo $__env->make('layouts.footer_script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
    function formSuccessFunction(response) {
        if(!response.error){
            setTimeout(() => {
                let url = "<?php echo e(route('home')); ?>"
                window.location.replace(url);
            }, 500);
        }
    }
</script>
</html>
<?php /**PATH /home/wrteam-shakir/ebroker/resources/views/customer/reset-password.blade.php ENDPATH**/ ?>